<?php
    $footer = getContent('footer.content', true);
    $footer_menu = getContent('footer.element', false);
    $socialIcons = getContent('social_icon.element');
?>
<footer class="footer-section bg--title-overlay bg_img bg_fixed" data-background="<?php echo e(getImage('assets/images/frontend/footer/'. $footer->data_values->background_image, '1920x1080')); ?>">
    <div class="footer-top pt-120 pb-120 position-relative">
        <div class="container">
            <div class="row gy-5 justify-content-between">
                <div class="col-lg-3">
                    <div class="footer__widget">
                        <div class="logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="<?php echo app('translator')->get('logo'); ?>">
                            </a>
                        </div>
                        <p>
                           <?php echo e(__($footer->data_values->heading)); ?>

                        </p>
                        <ul class="social-icons justify-content-start">
                            <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialIcon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e($socialIcon->data_values->url); ?>" target="__blank"><?php echo $socialIcon->data_values->social_icon ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="footer__widget">
                        <h5 class="title text--white"><?php echo app('translator')->get('Company'); ?></h5>
                        <ul class="useful-link">
                            <li>
                                <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                            </li>
                            <?php $__currentLoopData = $pages->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="footer__widget">
                        <h5 class="title text--white"><?php echo app('translator')->get('Useful Link'); ?></h5>
                        <ul class="useful-link">
                            <li>
                                <a href="<?php echo e(route('order.tracking')); ?>"><?php echo app('translator')->get('Order Tracking'); ?></a>
                            </li>
                            <?php $__currentLoopData = $footerPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-sm-6">
                    <div class="footer__widget">
                        <h5 class="title text--white"><?php echo app('translator')->get('Useful Link'); ?></h5>
                        <ul class="useful-link">
                            <?php $__currentLoopData = $footer_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e(route('footer.menu', [slug($value->data_values->menu), $value->id])); ?>"><?php echo e(__($value->data_values->menu)); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Support'); ?></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6">
                    <div class="footer__widget">
                        <h5 class="title text--white"><?php echo app('translator')->get('Get In Touch'); ?></h5>
                        <ul class="footer__widget-contact">
                            <li>
                                <i class="las la-map-marker"></i> <?php echo e(__($footer->data_values->address)); ?>

                            </li>
                            <li>
                                <i class="las la-mobile"></i> <?php echo app('translator')->get('Mobile'); ?>:  <?php echo e(__($footer->data_values->mobile)); ?>

                            </li>
                            <li>
                                <i class="las la-fax"></i> <?php echo app('translator')->get('Fax'); ?> :  <?php echo e(__($footer->data_values->fax)); ?>

                            </li>
                            <li>
                                <i class="las la-envelope"></i>  <?php echo e(__($footer->data_values->email)); ?>

                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom position-relative text-center">
        <div class="container">
            &copy; <?php echo app('translator')->get('All Right Reserved by'); ?> <a href="<?php echo e(route('home')); ?>"><?php echo e(__($general->sitename)); ?></a>
        </div>
    </div>
</footer>
<?php /**PATH /home/highogyr/public_html/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>